const mongoose = require("mongoose");

const userSchema = new mongoose.Schema({
  username: {
    type: String,
    required: true,
    unique: true,
  },
  email: {
    type: String,
    required: true,
    unique: true,
  },
  password: {
    type: String,
    required: true,
  },
  profile: {
    type: Object,
    default: {
      profilePicture: String, 
      phoneNumber: String,    
      linkedin: String,       
      location: String,       
      website: String,        
    },
  },
  role: {
    type: String,
    enum: ["job applicant", "admin", "nurse", "recruiter", "system"],
    default: "job applicant",
  },
  status: {
    type: String,
    enum: ["active", "suspended"],
    default: "active",
  },
  cvId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'File', // Reference to the file in GridFS
  },
}, {
  timestamps: true
});

module.exports = mongoose.model("User", userSchema);
