const mongoose = require("mongoose");

const applicationSchema = new mongoose.Schema(
  {
    applicant: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
    },
    job: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Job",
    },
    resume: {
      type: String,

    },
    coverLetter: {
      type: String,
    },
    status: {
      type: String,
      enum: ["applied", "interview", "hired", "rejected"],
      default: "applied",
    },
    firstName: { type: String },
    secondName: { type: String },
    lastName: { type: String },
    idNumber: { type: String },
    whatsAppNo: { type: String },  
    phoneNumber: {
      type: String,
    },
    email: { type: String },
    age: { type: Number},
    nationality: { type: String },
    location: { type: String},
    specialization: { type: String },
    positionapplied:{type:String},
    hasDrivingLicence: { type: String, enum: ["yes", "no"] },
    PassportNo:{type:String},
    academicLevel: {
      type: String,
      enum: [
        "Doctorate(PhD)",
        "Master's Degree",
        "Postgraduate Diploma",
        "Bachelor’s Degree",
        "Bachelor's Degree",
        "Associate's Degree",
        "Diploma",
        "Professional Certificate",
        "Certificate",
        "others",
      ],
      required: true, 
    },
    
    workExperience: [
      {
        company: { type: String },
        position: { type: String },
        duration: { type: String },
      },
    ],
    totalExperience: { type: String },
    salaryInfo: { type: String },
    viewed: { type: Boolean, default: false },
    cvFileId: { type: mongoose.Schema.Types.ObjectId, ref: 'cvs.files' },
    // cv: { type: String, default: null }
  },
  { timestamps: true }
);

const Application = mongoose.model("Application", applicationSchema);

module.exports = Application;
