const express = require("express");
const router = express.Router();
const Applicant = require("../models/Application"); 

router.put("/:id/viewed", async (req, res) => {
  try {
    const { id } = req.params;
    const updatedUser = await Applicant.findByIdAndUpdate(
      id,
      { $set: { viewed: true } },
      { new: true }
    );

    if (!updatedUser) {
      return res.status(404).json({ error: "User not found" });
    }

    res.status(200).json({ message: "User marked as viewed", updatedUser });
  } catch (error) {
    res.status(500).json({ error: "Server error" });
  }
});

router.put("/reset-viewed", async (req, res) => {
  try {
    await Applicant.updateMany({}, { $set: { viewed: false } });
    res.status(200).json({ message: "All users reset to unviewed" });
  } catch (error) {
    res.status(500).json({ error: "Server error" });
  }
});

module.exports = router;
